require "ISUI/EPIIPanel"

EasyPlacedItemIcons = EasyPlacedItemIcons or {};

--------------------------------------------------------------------------------
-- Helper functions for setting the global item lists --------------------------
--------------------------------------------------------------------------------

function EasyPlacedItemIcons.addItemsToSearchFor(items)
	if EasyPlacedItemIcons.itemsToSearchFor == nil then EasyPlacedItemIcons.itemsToSearchFor = {} end
	
	for k,v in pairs(items) do EasyPlacedItemIcons.itemsToSearchFor[k] = v end
end

function EasyPlacedItemIcons.addItemCategoriesToSearchFor(items)
	if EasyPlacedItemIcons.itemCategoriesToSearchFor == nil then EasyPlacedItemIcons.itemCategoriesToSearchFor = {} end
	
	for k,v in pairs(items) do EasyPlacedItemIcons.itemCategoriesToSearchFor[k] = v end
end

function EasyPlacedItemIcons.addItemDisplayCategoriesToSearchFor(items)
	if EasyPlacedItemIcons.itemDisplayCategoriesToSearchFor == nil then EasyPlacedItemIcons.itemDisplayCategoriesToSearchFor = {} end
	
	for k,v in pairs(items) do EasyPlacedItemIcons.itemDisplayCategoriesToSearchFor[k] = v end
end

function EasyPlacedItemIcons.addItemToSearchFor(item)
	if EasyPlacedItemIcons.itemsToSearchFor == nil then EasyPlacedItemIcons.itemsToSearchFor = {} end

	EasyPlacedItemIcons.itemsToSearchFor[item] = 1
end

function EasyPlacedItemIcons.addItemTypeToSearchFor(item)
	if EasyPlacedItemIcons.itemCategoriesToSearchFor == nil then EasyPlacedItemIcons.itemCategoriesToSearchFor = {} end

	EasyPlacedItemIcons.itemCategoriesToSearchFor[item] = 1
end

function EasyPlacedItemIcons.addItemDisplayCategoryToSearchFor(item)
	if EasyPlacedItemIcons.itemDisplayCategoriesToSearchFor == nil then EasyPlacedItemIcons.itemDisplayCategoriesToSearchFor = {} end

	EasyPlacedItemIcons.itemDisplayCategoriesToSearchFor[item] = 1
end

--------------------------------------------------------------------------------
-- Global Variables for mod settings -------------------------------------------
--------------------------------------------------------------------------------

EasyPlacedItemIcons.requireAiming = true
EasyPlacedItemIcons.keypressMode = 1

EasyPlacedItemIcons.searchForAll = false

EasyPlacedItemIcons.itemsToSearchFor = EasyPlacedItemIcons.itemsToSearchFor or {};
EasyPlacedItemIcons.addItemsToSearchFor({ ["Base.CarKey"]=1, ["Base.HouseKey"]=1, ["Base.Key"]=1, ["Base.Key2"]=1, ["Base.Key3"]=1, ["Base.Key4"]=1, ["Base.Key5"]=1, 
	["Base.KeyRing"]=1, ["Base.Needle"]=1, ["Base.Thread"]=1, ["Base.Screws"]=1, ["Base.Nails"]=1, ["Base.Cigarettes"]=1, ["Base.Lighter"]=1, ["Base.Matches"]=1,
	["Base.Battery"]=1, ["Base.Paperclip"]=1, });

EasyPlacedItemIcons.itemCategoriesToSearchFor = EasyPlacedItemIcons.itemCategoriesToSearchFor or {};
EasyPlacedItemIcons.addItemCategoriesToSearchFor({ ["Key"]=1, ["WeaponPart"]=1, });

EasyPlacedItemIcons.itemDisplayCategoriesToSearchFor = EasyPlacedItemIcons.itemDisplayCategoriesToSearchFor or {};
EasyPlacedItemIcons.addItemDisplayCategoriesToSearchFor({ ["Ammo"]=1, });

EasyPlacedItemIcons.searchMovementDelay = 0;
EasyPlacedItemIcons.searchPerformanceDelay = 0;

EasyPlacedItemIcons.iconSize = 60
EasyPlacedItemIcons.iconPadding = 5
EasyPlacedItemIcons.iconAlpha = 0.7

EasyPlacedItemIcons.maxIconColumns = 3
EasyPlacedItemIcons.maxIconRows = 3

EasyPlacedItemIcons.useMoreIcon = true
EasyPlacedItemIcons.useIconHighlight = true

--------------------------------------------------------------------------------
-- Non-global Variables for mod settings ---------------------------------------
--------------------------------------------------------------------------------

local EPII_Internal = {}

EPII_Internal.keyToggledOn = false

EPII_Internal.lastSearchTimeInMillis = 0;

EPII_Internal.lastSquareX = 0
EPII_Internal.lastSquareY = 0
EPII_Internal.lastSquareZ = 0
EPII_Internal.lastCursorMoveTimeInMillis = 0;

EPII_Internal.panel = nil;

--------------------------------------------------------------------------------
-- Helper function to allow for accessing the icon display panel ---------------
--------------------------------------------------------------------------------

function EasyPlacedItemIcons.getDisplayPanel()
	return EPII_Internal.panel
end

--------------------------------------------------------------------------------
-- Helper functions for core functionality -------------------------------------
--------------------------------------------------------------------------------

function EasyPlacedItemIcons.isSameSquare(x,y,z)
	return x == EPII_Internal.lastSquareX and y == EPII_Internal.lastSquareY and z == EPII_Internal.lastSquareZ
end

function EasyPlacedItemIcons.keypressToggler(keynum)
	if keynum == getCore():getKey("EPII_Activation_Key") then
		EPII_Internal.keyToggledOn = not EPII_Internal.keyToggledOn
	end
end

function EasyPlacedItemIcons.resetKeypressToggle()
	EPII_Internal.keyToggledOn = false
end

function EasyPlacedItemIcons.createPanel()
	if EPII_Internal.panel == nil then
		EPII_Internal.panel = EPIIPanel:new(0, 0, 0, 0, 1, EasyPlacedItemIcons.iconSize, EasyPlacedItemIcons.iconSize, EasyPlacedItemIcons.maxIconColumns, EasyPlacedItemIcons.maxIconRows, EasyPlacedItemIcons.useMoreIcon)

		EPII_Internal.panel:initialise()
		EPII_Internal.panel:addToUIManager()

		EPII_Internal.panel:setVisible(true)
	end
end

function EasyPlacedItemIcons.applyPanelOptions()
	if EPII_Internal.panel == nil then
		EasyPlacedItemIcons.createPanel()
	end
	
	EPII_Internal.panel:setIconSize(EasyPlacedItemIcons.iconSize)
	EPII_Internal.panel:setIconPadding(EasyPlacedItemIcons.iconPadding, EasyPlacedItemIcons.iconPadding)
	EPII_Internal.panel:setIconAlpha(EasyPlacedItemIcons.iconAlpha)
	
	EPII_Internal.panel:setPanelDimensions(EasyPlacedItemIcons.maxIconColumns, EasyPlacedItemIcons.maxIconRows)
	
	EPII_Internal.panel:setUseMoreIcon(EasyPlacedItemIcons.useMoreIcon)
	EPII_Internal.panel:setUseIconHighlight(EasyPlacedItemIcons.useIconHighlight)
	
	if EasyPlacedItemIcons.maxIconColumns == 1 and EasyPlacedItemIcons.maxIconRows == 1 then
		EPII_Internal.panel:setUsePanelBackgroundTex(true)
	else
		EPII_Internal.panel:setUsePanelBackgroundTex(false)
	end
	
	EPII_Internal.keypressToggler = false
end

--------------------------------------------------------------------------------
-- Main function ---------------------------------------------------------------
--------------------------------------------------------------------------------

function EasyPlacedItemIcons.prerenderUI()
	local player = getPlayer()

	if player == nil then return end

	local boundkey = getCore():getKey("EPII_Activation_Key")
	
	if (EasyPlacedItemIcons.requireAiming and not player:isAiming()) or 
	(EasyPlacedItemIcons.keypressMode == 1 and not isKeyDown(boundkey)) or
	(EasyPlacedItemIcons.keypressMode == 2 and not EPII_Internal.keyToggledOn) or
	UIManager.getSpeedControls():getCurrentGameSpeed() == 0 then
		EPII_Internal.panel:close()
		
        return
    end

	local currentTimeInMillis = getTimestampMs()
	
	local z = player:getZ();
	
	local playerNum = player:getPlayerNum()
	
	local zoom = getCore():getZoom(playerNum)
	
	local mx = getMouseX();
	local my = getMouseY();
	local simx = mx * zoom;
	local simy = my * zoom
	
	if player:isAiming() then simy = simy + 100 end

	local wx, wy = ISCoordConversion.ToWorld(simx, simy, z);

	local gridsquare = getCell():getGridSquare(wx, wy, z);

	wx = math.floor(wx);
	wy = math.floor(wy);
	
	local squareChanged = not EasyPlacedItemIcons.isSameSquare(wx, wy, z)
	
	if squareChanged then
		EPII_Internal.lastSquareX = wx
		EPII_Internal.lastSquareY = wy
		EPII_Internal.lastSquareZ = z
		
		EPII_Internal.lastCursorMoveTimeInMillis = currentTimeInMillis
		
		-- EPII_Internal.panel:close()
	end

	if (currentTimeInMillis - EPII_Internal.lastSearchTimeInMillis >= EasyPlacedItemIcons.searchPerformanceDelay) then
		EPII_Internal.lastSearchTimeInMillis = currentTimeInMillis
		
		EPII_Internal.panel:reset()

		local worldItems = gridsquare:getWorldObjects()
		local worldItem = nil
		
		local i = 1
		while i <= worldItems:size() do
			worldItem = worldItems:get(i - 1)
			
			if worldItem ~= nil then
				local placedItem = worldItem:getItem()
				
				if placedItem ~= nil then
					--local itemModule = placedItem:getModule()
					--local itemDisplayName = placedItem:getName()

					local itemInternalType = placedItem:getFullType()
					local itemCategory = placedItem:getCategory()
					local itemDisplayCategory = placedItem:getDisplayCategory()
					
					if EasyPlacedItemIcons.searchForAll or EasyPlacedItemIcons.itemsToSearchFor[itemInternalType] == 1 or 
					EasyPlacedItemIcons.itemCategoriesToSearchFor[itemCategory] == 1 or EasyPlacedItemIcons.itemDisplayCategoriesToSearchFor[itemDisplayCategory] == 1 then
						local curTex = placedItem:getTex()

						EPII_Internal.panel:addIcon(curTex)
						
						-- Stop checking world objects if we have filled our display panel to save some processing time
						if EPII_Internal.panel:isFull() then i = worldItems:size() end
					end
				end
			end
			
			i = i + 1
		end
	end
	
	if not EPII_Internal.panel:isEmpty() and (currentTimeInMillis - EPII_Internal.lastCursorMoveTimeInMillis >= EasyPlacedItemIcons.searchMovementDelay) then
		EPII_Internal.panel:reposition(mx, my, zoom)
		
		EPII_Internal.panel:setVisible(true)
	else
		EPII_Internal.panel:close()
	end
end

Events.OnKeyPressed.Add(EasyPlacedItemIcons.keypressToggler);

Events.OnCreateUI.Add(EasyPlacedItemIcons.createPanel);

Events.OnPreUIDraw.Add(EasyPlacedItemIcons.prerenderUI);